package jamezo97.clonecraft.network;

import jamezo97.clonecraft.Synchronize.SyncData;
import jamezo97.clonecraft.Synchronize.Synchronizable;
import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler15Synchronize extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	int[] ids;
	
	@Value(id = 2)
	Object[] values;
	
	public Handler15Synchronize(Entity entity, SyncData... data) {
		entityId = entity.entityId;
		
		int size = 0;
		for(int a = 0; a < data.length; a++){
			size += data[a].idToValue.size();
		}
		ids = new int[size];
		values = new Object[size];
		int index = 0;
		for(int a = 0; a < data.length; a++){
			for(int b = 0; b < data[a].ids.size(); b++){
				int id = data[a].ids.get(b);
				Object value = data[a].idToValue.get(id);
				ids[index] = id;
				values[index++] = value;
//				System.out.println(values[index-1]);
			}
		}
	}
	
	public Handler15Synchronize() {
		
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		Entity e = this.getEntityOnSide(side, entityId, player.worldObj.provider.dimensionId);
		if(e != null && e instanceof Synchronizable){
			((Synchronizable)e).getSyncer().recieveData(new SyncData(-1).importValues(ids, values), player);
		}
	}



	
	
}
